using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
// Import MySql Data, MySqlClient and System.IO namespaces
using MySql.Data;
using MySql.Data.MySqlClient;
using System.IO;

public partial class _SelectMysql : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // This code will only be executed if the page load not is a post back.
        if (!Page.IsPostBack)
        {
            // Get values from session variables and store these values in hidden fields.
            HiddenCompanyID.Value = Convert.ToString(Session["CompanyID"]);
            HiddenYearID.Value = Convert.ToString(Session["YearID"]);
            HiddenCompanyName.Value = Convert.ToString(Session["CompanyName"]);
        }
    }

    protected void BtnSelectAssets_Click(object sender, EventArgs e)
    {
        // This is code to select data to a dataset with two tables so that we kan make groups and calculate values
        // Asset accounts in parentrepeater and assets inside childrepeater.

        // Declare variables for a connection string and two SELECT statements.
        string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
        string sql = "SELECT AssetTypeID, AssetAccount, TypeName FROM AssetType WHERE CompanyID = @CompanyID "
        + "GROUP BY AssetTypeID, AssetAccount, TypeName ORDER BY AssetAccount ASC";
        string sql2 = "SELECT A.AssetOwnID, A.AssetType, A.AssetName, A.PurchaseDate, A.PurchasePrice, "
        + "SUM(COALESCE(SumIB, 0)) As YearIB, SUM(COALESCE(SumYearDep,0)) As YearDep, SUM(COALESCE(SumIB, 0) "
        + "+ COALESCE(SumYearDep,0)) As SumAckDeprication, SUM(A.PurchasePrice - (COALESCE(SumIB, 0) + "
        + "COALESCE(SumYearDep,0))) As AccountedValue FROM Assets AS A LEFT OUTER JOIN (SELECT AssetID, "
        + "SUM(IBValue) As SumIB FROM IBDeprication WHERE YearID = @YearID GROUP BY AssetID) As IB ON A.AssetID "
        + "= IB.AssetID LEFT OUTER JOIN (SELECT AssetID, SUM(DepricationValue) As SumYearDep FROM Deprication "
        + "WHERE YearID = @YearID GROUP BY AssetID) AS D ON A.AssetID = D.AssetID WHERE A.CompanyID = @CompanyID "
        + "AND A.SoldScraped = '0' OR A.DateSold > @Slutdatum GROUP BY A.AssetOwnID, A.AssetType, A.AssetName, "
        + "A.PurchaseDate, A.PurchasePrice ORDER BY A.PurchaseDate ASC";

        // Create a MySqlConnection. The using block is used to call dispose (close) automatically even if there 
        // are an exception.
        using (MySqlConnection cn = new MySqlConnection(ConnString))
        {
            // Create the first MySqlDataAdapter.
            MySqlDataAdapter ad = new MySqlDataAdapter();

            // Create the first MySqlCommand.
            MySqlCommand cmd = new MySqlCommand(sql, cn);

            // Create the second MySqlDataAdapter.
            MySqlDataAdapter ad2 = new MySqlDataAdapter();

            // Create the second MySqlCommand.
            MySqlCommand cmd2 = new MySqlCommand(sql2, cn);

            // Create a new dataset, a dataset can contain several datatables that are related to each other.
            DataSet ds = new DataSet();

            // Add parameters.
            cmd.Parameters.AddWithValue("@CompanyID", HiddenCompanyID.Value);
            cmd2.Parameters.AddWithValue("@YearID", HiddenYearID.Value);
            cmd2.Parameters.AddWithValue("@CompanyID", HiddenCompanyID.Value);
            cmd2.Parameters.AddWithValue("@Slutdatum", txtEndDate.Text);

            // The Try/Catch/Finally block is used to handle exceptions in the application.
            try
            {
                // Open the MySqlConnection.
                cn.Open();

                // Fill dataset with assettypes as the first table.
                ad.SelectCommand = cmd;
                ad.Fill(ds, "AssetTypes");

                // Fill dataset with assets as the second table.
                ad2.SelectCommand = cmd2;
                ad2.Fill(ds, "Assets");

                // Create the relation bewtween the AssetTypes and Assets tables.
                ds.Relations.Add("assetsrelation", ds.Tables["AssetTypes"].Columns["AssetTypeID"], ds.Tables["Assets"].Columns["AssetType"]);

                // Calculate subtotals
                DataColumn PPTotal = new DataColumn("PPTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).PurchasePrice)");
                PPTotal.AutoIncrement = false;
                PPTotal.ReadOnly = true;
                DataColumn IBTotal = new DataColumn("IBtotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).YearIB)");
                IBTotal.AutoIncrement = false;
                IBTotal.ReadOnly = true;
                DataColumn YearTotal = new DataColumn("YearDepTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).YearDep)");
                YearTotal.AutoIncrement = false;
                YearTotal.ReadOnly = true;
                DataColumn AckDepTotal = new DataColumn("AckDepTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).SumAckDeprication)");
                AckDepTotal.AutoIncrement = false;
                AckDepTotal.ReadOnly = true;
                DataColumn AccValueTotal = new DataColumn("AccValueTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).AccountedValue)");
                AccValueTotal.AutoIncrement = false;
                AccValueTotal.ReadOnly = true;

                // Add columns to the AssetTypes table.
                ds.Tables["AssetTypes"].Columns.Add(PPTotal);
                ds.Tables["AssetTypes"].Columns.Add(IBTotal);
                ds.Tables["AssetTypes"].Columns.Add(YearTotal);
                ds.Tables["AssetTypes"].Columns.Add(AckDepTotal);
                ds.Tables["AssetTypes"].Columns.Add(AccValueTotal);

                // Bind the AssetTypes table to the parentrepeater control, and call DataBind. Data for the 
                // childrepeater will be retrieved in Select-mysql.aspx from the dataset.
                parentRepeater.DataSource = ds.Tables["AssetTypes"];
                Page.DataBind();
            }
            catch (Exception ex)
            {
                // Catch a general exception.
                Response.Write(ex.Message);
            }
            finally
            {
                // Dispose of MySqlDataAdapters, MySqlCommands and the DataSet.
                ad.Dispose();
                ad2.Dispose();
                cmd.Dispose();
                cmd2.Dispose();
                ds.Dispose();
            }
        }
    }
    protected void ImportIB_Click(object sender, EventArgs e)
    {
        
        // When the user clicks the button to import opening balance we select opening balance from the database
        // and bind the data to a repeater control.

        string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
        string sql = "SELECT A.AssetID, A.AssetOwnID, A.AssetName, SUM(COALESCE(SumDeprication, 0)+"
        + "COALESCE(IBDeprication, 0)) AS UBValue FROM Assets AS A LEFT OUTER JOIN (SELECT AssetID, "
        + "SUM(DepricationValue) AS SumDeprication FROM Deprication WHERE YearID = @YearID GROUP BY AssetID) "
        + "AS D ON A.AssetID = D.AssetID LEFT OUTER JOIN (SELECT AssetID, SUM(IBValue) AS IBDeprication FROM "
        + "IBDeprication WHERE YearID = @YearID GROUP BY AssetID) AS IB ON A.AssetID = IB.AssetID "
        + "WHERE A.CompanyID = @CompanyID AND SoldScraped = '0' GROUP BY A.AssetID, A.AssetOwnID, A.AssetName";


        // Create a MySqlConnection. The using block is used to call dispose (close) automatically even if 
        // there are an exception.
        using (MySqlConnection cn = new MySqlConnection(ConnString))
        {
            // Create a MySqlCommand.
            MySqlCommand cmd = new MySqlCommand(sql, cn);

            // Create a MySqlDataReader.
            MySqlDataReader reader = null;

            // Add parameters for the WHERE clause.
            cmd.Parameters.AddWithValue("@CompanyID", HiddenCompanyID.Value);
            cmd.Parameters.AddWithValue("@YearID", YearDropDown.SelectedValue);

            // The Try/Catch/Finally block is used to handle exceptions in the application.
            try
            {
                // Open the SqlConnection.
                cn.Open();

                // Execute the SELECT statement and assign the result to the reader.
                reader = cmd.ExecuteReader();

                // Set the datasource for the repeater and bind data to it.
                AddAckAvskrRepeater.DataSource = reader;
                AddAckAvskrRepeater.DataBind();
            }
            catch (Exception ex)
            {
                // Catch a general exception.
                Response.Write(ex.Message);
            }
            finally
            {
                // Dispose the MySqlCommand.
                cmd.Dispose();

                // Close the reader to avoid memory leakage.
                if (reader != null)
                    reader.Close();
            }
        }
    }
    protected void SaveIB_Click(object sender, EventArgs e)
    {
        // When the user clicks the button to save opening balance we look att each row in the repeater control
        // and insert data if there is no corresponding post with AssetID and YearID in the table or update the
        // post if there already are a post with the actual AssetID and YearID in the table.

        if (!string.IsNullOrEmpty(HiddenYearID.Value) & !string.IsNullOrEmpty(HiddenCompanyID.Value))
        {
            // Foreach loop in Repeater.
            foreach (RepeaterItem RepeaterRow in AddAckAvskrRepeater.Items)
            {
                Literal AssetIDLiteralLt = (Literal)RepeaterRow.FindControl("AssetIDLiteral");
                TextBox IBackAvskrivningarTb = (TextBox)RepeaterRow.FindControl("IBackAvskrivningar");

                if (!string.IsNullOrEmpty(IBackAvskrivningarTb.Text))
                {

                    string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
                    string sql = "INSERT INTO IBDeprication (AssetID, YearID, IBValue) VALUES (@AssetID, @YearID, @IBValue)";

                    // The using block is used to call dispose (close) automatically even if there are an exception.
                    using (MySqlConnection cn = new MySqlConnection(ConnString))
                    {
                        // Create a MySqlCommand.
                        MySqlCommand cmd = new MySqlCommand(sql, cn);

                        // Add parameters.
                        cmd.Parameters.AddWithValue("@AssetID", AssetIDLiteralLt.Text);
                        cmd.Parameters.AddWithValue("@YearID", HiddenYearID.Value);
                        cmd.Parameters.AddWithValue("@IBValue", IBackAvskrivningarTb.Text);

                        try
                        {
                            cn.Open();
                            cmd.ExecuteNonQuery();
                        }
                        catch (MySqlException ex)
                        {
                            switch (ex.Number)
                            {
                                case 1062:
                                    // If the AssetID already exists in the table then we update the asset instead.
                                    updateIBDeprication(AssetIDLiteralLt.Text, HiddenYearID.Value, IBackAvskrivningarTb.Text);
                                    break;
                                default:
                                    Response.Write(ex.Message);
                                    break;
                            }
                        }
                        catch (Exception Exc)
                        {
                            Response.Write(Exc.Message);
                        }
                        finally
                        {
                            cmd.Dispose();
                        }
                    }

                    // Redirect the user to another web page.
                    Server.Transfer("New-page.aspx");
                }
                else
                {
                    ErrorLabel.Text = "* You have to select a company and accounting year";
                }
            }
        }
    }

    protected void updateIBDeprication(string AssetID, string YearID, string IBValue)
    {
        string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
        string sql = "UPDATE IBDeprication SET IBValue = @IBValue WHERE AssetID = @AssetID AND YearID = @YearID";

        // The using block is used to call dispose (close) automatically even if there are an exception.
        using (MySqlConnection cn = new MySqlConnection(ConnString))
        {
            MySqlCommand cmd = new MySqlCommand(sql, cn);

            // Add parameters.
            cmd.Parameters.AddWithValue("@AssetID", AssetID);
            cmd.Parameters.AddWithValue("@YearID", YearID);
            cmd.Parameters.AddWithValue("@IBValue", IBValue);

            try
            {
                cn.Open();
                cmd.ExecuteNonQuery();
            }
            catch (Exception Exc)
            {
                Response.Write(Exc.Message);
            }
            finally
            {
                cmd.Dispose();
            }
        }
    }
}
